
/**HEADER********************************************************************
* 
* Copyright (c) 2010 Linear Tech Corporation;
* All Rights Reserved
*
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: cgi.c$
* $Version : 3.0.11.0$
* $Version : Custom for LTC Board Demo Suite
* $Date    : Sep-10-2010$
*
* Comments:
*
*   Example of CGI using RTCS.
*
*END************************************************************************/

//>>>>>>>>>>>>>>>>>>>>>>>>
//cgi.h
//cgi.c
//>>>>>>>>>>
//Contains the CGI function list, and the Function Link list.
//Also, contains the usb_status_fn that tells the website whether a USB drive is connected or not.
//



#include <httpd.h>
#include <cgi.h>

#include <string.h>



extern LWSEM_STRUCT      USB_Stick;
static void usb_status_fn(HTTPD_SESSION_STRUCT *session);



//The first entry is the testdata.cgi call in the HTML file
//The second entry is the function that will be processing that call
const HTTPSRV_CGI_LINK_STRUCT cgi_lnk_tbl[] = {
	{ "ipstat",			cgi_ipstat},
	{ "icmpstat",		cgi_icmpstat},
	{ "udpstat",		cgi_udpstat},
	{ "tcpstat",		cgi_tcpstat},
	{ "rtcdata",		cgi_rtc_data},
	{ "toggleled1",		cgi_toggle_led1},
	{ "toggleled2",		cgi_toggle_led2},
	{ "toggleled3",		cgi_toggle_led3},
	{ "toggleled4",		cgi_toggle_led4},
	{ "button1",            cgi_button_1},
	{ "testdata",		cgi_test_data},
	//{ "receivedata",    cgi_receive_data},
	
	//LTC1859
	{ "ltc1859data",    cgi_ltc1859_data},
	{ "ltc1859set",     cgi_ltc1859_set},
	
	//LTC2498
	{ "ltc2498data",    cgi_ltc2498_data},
	{ "ltc2498set",     cgi_ltc2498_set},
	
	//LTC2600
	{ "ltc2600set",     cgi_ltc2600_set},
	
	//LTC2704
	{ "ltc2704set",     cgi_ltc2704_set},
	
	//Datalogger
	{ "adcloggerset",     cgi_adcdatalogger_set},
	{ "samplerprogress", cgi_sampler_progress},
        { "syncrtc",          cgi_sync_rtc},
	
	//Thermocouple
	{ "thermocoupleset",     cgi_thermocouple_set},
	{ "thermocoupledata", cgi_thermocouple_data},
		
	{ 0, 0 }    // DO NOT REMOVE - last item - end of table
};



const HTTPD_FN_LINK_STRUCT fn_lnk_tbl[] = {
	{ "usb_status_fn",  usb_status_fn },
	{ 0, 0 }
};


static void usb_status_fn(HTTPD_SESSION_STRUCT *session) {
   	if (USB_Stick.VALUE)
   		httpd_sendstr(session->sock, "visible");
   	else
   		httpd_sendstr(session->sock, "hidden");
}

